#ifndef MAIN_WINDOW_H
#define MAIN_WINDOW_H

#include <qmainwindow.h>
#include "ui_mainwindow.h"
#include "aboutwindow.h"
#include "guideview.h"

class MainWindow : public QMainWindow, public Ui_MainWindow
{
    Q_OBJECT

    AboutWindow *about;
    void maximal_extensions();
    void maximal_cliques();
    void isomorphism_classes();
    void choose_file(QLineEdit*, QString, QString, bool);
    void choose_input_file(QLineEdit*, QString, QString);
    void choose_output_file(QLineEdit*, QString, QString);

public:

    MainWindow(QWidget *);

private slots:

    void compute();
    void showWorkspace();
    void showGuide();
    void select_input_extensions_file();
    void select_good_vert_file();
    void select_e_graph_file();
    void select_good_sets_file();
    void select_max_ext_file();
    void select_input_cliques_file();
    void select_output_cliques_file();
    void select_input_isomorphism_file();
    void select_output_isomorphism_file();
    void view_goodvert();
    void view_egraph();
    void view_goodsets();
    void view_maxext();
    void view_cliques();
    void view_classes();
    void check();
};

#endif
